package com.hero.objects.modifiers;

import java.text.NumberFormat;
import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.ui.dialog.UOODialog;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class UsableOnOthers extends Modifier {

	private static String xmlID = "UOO";

	public UsableOnOthers(Element root) {
		super(root, UsableOnOthers.xmlID);
	}

	@Override
	public String getAlias() {
		if (getSelectedOption() == null) {
			if (getOptions().size() > 0) {
				return ((GenericObject) getOptions().get(0)).getAlias();
			} else {
				return super.getAlias();
			}
		}
		return getSelectedOption().getAlias();
	}

	@Override
	public ArrayList<Adder> getAssignedAdders() {
		ArrayList<Adder> ret = super.getAssignedAdders();
		if (!HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
			return ret;
		}
		if ((getSelectedOption() != null)
				&& !(getSelectedOption().getXMLID().equals("SIMULTANEOUSLY") || getSelectedOption()
						.getXMLID().equals("UAA"))) {
			for (int i = ret.size() - 1; i >= 0; i--) {
				Adder ad = ret.get(i);
				if (ad.getXMLID().equals("TARGETS")) {
					ret.remove(ad);
				}
			}
		}
		return ret;
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += ":  ";
			}
			ret += getInput();
		}
		if ((getSelectedOption() != null)
				&& getSelectedOption().getXMLID().equals("SIMULTANEOUSLY")) {
			Adder all = (Adder) findObjectByID(getAssignedAdders(),
					"ALLINRANGE");
			if (all != null) {
				ret += " ("+all.getAlias();
				all.setDisplayInString(false);
			} else {
				long number = 2;
				for (Adder ad : getAssignedAdders()) {
					if (ad.getXMLID().equals("TARGETS")) {
						ad.setDisplayInString(false);
						number = (int) (number * Math.pow(ad.getLevelPower(),
								ad.getLevels()));
					}
				}
				ret += " (up to " + NumberFormat.getInstance().format(number)
						+ " people at once";
			}
		}
		if ((getSelectedOption() != null)
				&& getSelectedOption().getXMLID().equals("UAA")) {
			long number = 1;
			for (Adder ad : getAssignedAdders()) {
				if (ad.getXMLID().equals("TARGETS")) {
					ad.setDisplayInString(false);
					number = (int) (number * Math.pow(ad.getLevelPower(), ad
							.getLevels()));
					ret += " (x" + NumberFormat.getInstance().format(number)
							+ " maximum weight per inanimate target";
				}
			}
		}

		int index = 0;
		int parenCount = 0;
		while (ret.indexOf("(", index) >= 0) {
			parenCount++;
			index = ret.indexOf("(", index) + 1;
		}
		index = 0;
		while (ret.indexOf(")", index) >= 0) {
			parenCount--;
			index = ret.indexOf(")", index) + 1;
		}
		if (parenCount <= 0) {
			ret += " (";
		} else {
			ret += "; ";
		}

		double val = getTotalValue();
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		ret += getFraction(val) + ")";
		for (Adder ad : getAssignedAdders()) {
			if (!ad.displayInString()) {
				continue;
			}
			if (adderString.length() > 0) {
				adderString += ", ";
			}
			adderString += ad.getAlias();
		}

		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		if (adderString.trim().length() > 0) {
			ret += ", ";
			ret += adderString;
		}

		return ret;
	}

	@Override
	public ModifierDialog getDialog(GenericObject parent, boolean isNew) {
		return new UOODialog(this, isNew, parent);
	}

	@Override
	public ArrayList<Adder> getOptions() {
		ArrayList<Adder> ret = (ArrayList<Adder>) super.getOptions().clone();
		if (!HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
			return ret;
		}
		if ((parent == null)
				|| (parent.getDefense().equals("NONE") && !(parent.getTarget()
						.equals("DCV") || parent.getTarget().equals("ECV")))) {
			return ret;
		} else if (parent != null) {
			ArrayList<Modifier> orig = parent.getAssignedModifiers();
			if (GenericObject.findObjectByID(orig, "UOO") != null) {
				ArrayList<Modifier> temp = (ArrayList<Modifier>) orig.clone();
				temp.remove(GenericObject.findObjectByID(temp, "UOO"));
				parent.setAssignedModifiers(temp);
				if (parent.getDefense().equals("NONE")
						&& !(parent.getTarget().equals("DCV") || parent
								.getTarget().equals("ECV"))) {
					parent.setAssignedModifiers(orig);
					return ret;
				}
				parent.setAssignedModifiers(orig);
			}
		}
		for (int i = ret.size() - 1; i >= 0; i--) {
			Adder ad = ret.get(i);
			if (ad.getXMLID().equals("UAA")) {
				ret.remove(i);
			}
		}
		return ret;
	}
}